%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% filtered outdegree calculator (off of a collapsed transition matrix)

function [FOD] = calcFOD(Tcost,Ttime,cost_thresh,time_thresh)
% Inputs
%   Tcost and Ttime - {1 by Rules} cell array of (design,design) matrices indicating transition costs from row to col.
%                       A zero should indicate no available transitions
%   cost_thresh and time_thresh - scalars for max allowable costs

% Outputs
%   FOD - a (design,1) vector of FOD scores for the designs

numDesigns = size(Tcost{1},1);
numRules = length(Tcost);
FOD = zeros(numDesigns,1);

for r = 1:numRules
    idx1 = Tcost{r} > 0;
    idx2 = Tcost{r} <= cost_thresh;
    idx3 = Ttime{r} <= time_thresh;
    idxF = (idx1+idx2+idx3)==3;
    FOD = FOD + sum(idxF,2);
end


end